package aln.SpawnCommands;

import java.util.Arrays;
import java.util.List;

import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import cpw.mods.fml.common.registry.GameData;

public class CommandSpawnBlockData implements ICommand {
  
  @Override
  public int compareTo(Object arg0) {
    return 0;
  }
  
  @Override
  public String getCommandName() {
    return "spawnblockdata";
  }
  
  @Override
  public String getCommandUsage(ICommandSender sender) {
    return "/spawnblockdata   displays data about the blocks you are standing in and on.";
  }
  
  @Override
  public List getCommandAliases() {
    return Arrays.asList(new String[] { });
  }
  
  @Override
  public void processCommand(ICommandSender sender, String[] params) throws CommandException {
    if (!(sender instanceof EntityPlayer)) { return; }
    EntityPlayer player = (EntityPlayer) sender;
    World world = player.worldObj;
    if ( world.isRemote ) { return; }
    
    // command permissions. "no" is handled by not registering the command at all. "op" and "enable" are handled here. "all" is the default.
    SpawnCommands.loadCommandPermissionsConfig();
    if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawnblockdata").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
    { Do.Say(player,"Op only command.  You are not an op."); return; }
    if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawnblockdata").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
    { Do.Say(player,"Advanced spawn commands are not enabled."); return; }
    
    if ( (params.length > 0) && (params[0].equalsIgnoreCase("help")) ) { SpawnCommands.showHelp(player); return; }
    Do.Say(player, " ");
    
    // mc1.8
    //double  px = Math.round(player.getPosition().getX() - .5); // player's coordinates rounded down
    //double  py = Math.round(player.getPosition().getY() - .5);
    //double  pz = Math.round(player.getPosition().getZ() - .5);
    //mc 1.7.10
    double  px = Math.round(player.posX - .5); // player's coordinates rounded down
    double  py = Math.round(player.posY - .5);
    double  pz = Math.round(player.posZ - .5);
      
    py--; // targeting the block below feet
    
    if ( py < 0 ) { Do.Say(player, "There is nothing below your feet."); return; }
    if ( py > world.getActualHeight() ) { Do.Say(player, "You are above the sky limit for blocks."); return; }
    
    // mc1.8
    //Do.Say(player,"§8Dimension name "+world.provider.getDimensionName()+"§r"); // check for 1.8 compat
    //BlockPos pos = new BlockPos(px,py,pz);
    //Do.Say(player, "Block at x"+ (int)px +" y"+ (int)py +" z"+ (int)pz +" §ebelow player§r "+ player.getName());
    //Do.Say(player, "Block name "+ GameData.getBlockRegistry().getNameForObject(world.getBlockState(pos).getBlock()) +" with meta data "+ player.worldObj.getChunkFromBlockCoords(pos).getBlockMetadata(pos) );
    //Do.Say(player, "§8"+world.getBlockState(pos).toString()+"§r");
    //if ( world.getBlockState(pos).getBlock().hasTileEntity(world.getBlockState(pos)) ) { Do.Say(player, "§8Block is a tileEntity.§r"); } 
    // mc1.7.10
    Do.Say(player,"§8Dimension name "+world.provider.getDimensionName()+"§r");
    Do.Say(player, "Block at x"+ (int)px +" y"+ (int)py +" z"+ (int)pz +" §ebelow player§r "+ player.getGameProfile().getName());
    Do.Say(player, "Block name "+ GameData.getBlockRegistry().getNameForObject(world.getBlock((int)px,(int)py,(int)pz)) +" with meta data "+ world.getBlockMetadata((int)px,(int)py,(int)pz) );
    Do.Say(player, "§8"+world.getBlock((int)px,(int)py,(int)pz).toString()+"§r");
    if ( world.getBlock((int)px,(int)py,(int)pz).hasTileEntity( world.getBlockMetadata((int)px,(int)py,(int)pz) ) ) { Do.Say(player, "§8Block is a tileEntity.§r"); } 
    
    // mc1.8
    //pos = new BlockPos(px,py+1,pz);
    //Do.Say(player, "§eAt feet§r "+ GameData.getBlockRegistry().getNameForObject(world.getBlockState(pos).getBlock()) +" with meta data "+ player.worldObj.getChunkFromBlockCoords(pos).getBlockMetadata(pos) );
    //Do.Say(player, "§8"+world.getBlockState(pos).toString()+"§r");
    //if ( world.getBlockState(pos).getBlock().hasTileEntity(world.getBlockState(pos)) ) { Do.Say(player, "§8Block is a tileEntity.§r"); } 
    // mc1.7.10
    py++;
    Do.Say(player, "§eAt feet§r "+ GameData.getBlockRegistry().getNameForObject(world.getBlock((int)px,(int)py,(int)pz)) +" with meta data "+ world.getBlockMetadata((int)px,(int)py,(int)pz) );
    Do.Say(player, "§8"+world.getBlock((int)px,(int)py,(int)pz).toString()+"§r");
    if ( world.getBlock((int)px,(int)py,(int)pz).hasTileEntity( world.getBlockMetadata((int)px,(int)py,(int)pz) ) ) { Do.Say(player, "§8Block is a tileEntity.§r"); } 
    // example:   Railcraft:tile.railcraft.residual.heat
    
    // mc1.8
    //pos = new BlockPos(px,py+2,pz);
    //Do.Say(player, "§eAt head§r "+ GameData.getBlockRegistry().getNameForObject(world.getBlockState(pos).getBlock()) +" with meta data "+ player.worldObj.getChunkFromBlockCoords(pos).getBlockMetadata(pos) );
    //Do.Say(player, "§8"+world.getBlockState(pos).toString()+"§r");
    //if ( world.getBlockState(pos).getBlock().hasTileEntity(world.getBlockState(pos)) ) { Do.Say(player, "§8Block is a tileEntity.§r"); } 
    // mc1.7.10
    py++;
    Do.Say(player, "§eAt head§r "+ GameData.getBlockRegistry().getNameForObject(world.getBlock((int)px,(int)py,(int)pz)) +" with meta data "+ world.getBlockMetadata((int)px,(int)py,(int)pz) );
    Do.Say(player, "§8"+world.getBlock((int)px,(int)py,(int)pz).toString()+"§r");
    if ( world.getBlock((int)px,(int)py,(int)pz).hasTileEntity( world.getBlockMetadata((int)px,(int)py,(int)pz) ) ) { Do.Say(player, "§8Block is a tileEntity.§r"); } 
  }
  
  @Override
  public boolean canCommandSenderUseCommand(ICommandSender sender) {
    return true;
  }
  
  @Override
  //public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) { // mc1.8
  public List addTabCompletionOptions(ICommandSender icommandsender, String[] astring) { // mc1.7.10
    return null;
  }
  
  @Override
  public boolean isUsernameIndex(String[] args, int index) {
    return false;
  }
  
}
